package com.xforceplus.seller.invoice.client.model;

import com.xforceplus.seller.invoice.client.model.enums.ExportQueryCountType;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 查询导出count请求
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class QueryExportCountRequest {
    private String searchModel;
    private Boolean queryItemCount = false;
    private ExportQueryCountType exportQueryCountType;
    @ApiModelProperty("条件满足时是否从mysql查询")
    private Boolean queryFromMysql = false;
    private Integer originGroupsSize = 0;
}
