package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * QueryInvoicesBySaleItemIdsResult
 */

@JsonInclude(NON_NULL)
public class QueryInvoicesBySaleItemIdsResult {

    @JsonProperty("invoices")
    private List<QuerySellerInvoice> invoices;

    @ApiModelProperty(value = "发票列表")
    public List<QuerySellerInvoice> getInvoices() {
        return invoices;
    }

    public void setInvoices(List<QuerySellerInvoice> invoices) {
        this.invoices = invoices;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((invoices == null) ? 0 : invoices.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QueryInvoicesBySaleItemIdsResult other = (QueryInvoicesBySaleItemIdsResult) obj;
        if (invoices == null) {
            if (other.invoices != null)
                return false;
        } else if (!invoices.equals(other.invoices))
            return false;
        return true;
    }

}
