package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * QuerySaleItemIdsByInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class QuerySaleItemIdsByInvoiceRequest {

    @JsonProperty("invoiceNo")
    private String invoiceNo = null;

    @JsonProperty("invoiceCode")
    private String invoiceCode = null;

    @ApiModelProperty(value = "发票号码")
    public String getInvoiceNo() {
        return invoiceNo;
    }

    public void setInvoiceNo(String invoiceNo) {
        this.invoiceNo = invoiceNo;
    }

    @ApiModelProperty(value = "发票代码")
    public String getInvoiceCode() {
        return invoiceCode;
    }

    public void setInvoiceCode(String invoiceCode) {
        this.invoiceCode = invoiceCode;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((invoiceCode == null) ? 0 : invoiceCode.hashCode());
        result = prime * result + ((invoiceNo == null) ? 0 : invoiceNo.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QuerySaleItemIdsByInvoiceRequest other = (QuerySaleItemIdsByInvoiceRequest) obj;
        if (invoiceCode == null) {
            if (other.invoiceCode != null)
                return false;
        } else if (!invoiceCode.equals(other.invoiceCode))
            return false;
        if (invoiceNo == null) {
            if (other.invoiceNo != null)
                return false;
        } else if (!invoiceNo.equals(other.invoiceNo))
            return false;
        return true;
    }

}
