package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * QuerySaleItemIdsByInvoiceResult
 */

@JsonInclude(NON_NULL)
public class QuerySaleItemIdsByInvoiceResult {

    @JsonProperty("saleItemIds")
    private List<Long> saleItemIds;

    public List<Long> getSaleItemIds() {
        return saleItemIds;
    }

    public void setSaleItemIds(List<Long> saleItemIds) {
        this.saleItemIds = saleItemIds;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((saleItemIds == null) ? 0 : saleItemIds.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        QuerySaleItemIdsByInvoiceResult other = (QuerySaleItemIdsByInvoiceResult) obj;
        if (saleItemIds == null) {
            if (other.saleItemIds != null)
                return false;
        } else if (!saleItemIds.equals(other.saleItemIds))
            return false;
        return true;
    }

}
