package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "发票信息")
@JsonInclude(NON_NULL)
@Data
@EqualsAndHashCode
public class QuerySellerInvoice {
    @JsonProperty("invoice")
    private SellerInvoiceInfo invoice;
    @JsonProperty("items")
    private List<InvoiceItem> items;
    @JsonProperty("sellerInvoiceVehicleInfo")
    private SellerInvoiceVehicleInfo sellerInvoiceVehicleInfo;
    
}
