package com.xforceplus.seller.invoice.client.model;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 红字信息审核状态
 */
@Getter
@AllArgsConstructor
public enum RedNoApplyStatusEnum implements ValueEnum<Integer>{

    OTHERS(0,"其他状态"),
    APPROVED(1,"审核通过"),
    NOT_APPROVED(2,"审核不通过"),
    VERIFICATION(3,"已核销"),
    REVOKED(4,"已撤销"),
    VERIFICATION_AND_TO_BE_VERIFIED(5,"已核销，待查证");

    private final Integer value;
    private final String desc;

}
