package com.xforceplus.seller.invoice.client.model;

public enum RedNoGeneratePdfModel {

    Merge_All(0, "全部合并"),

    Split_By_Seller(1, "按销方公司拆分"),

    Split_By_Purchaser(2,"按购方公司拆分");

    private final Integer type;

    private final String description;

    RedNoGeneratePdfModel(Integer type, String description){
        this.type = type;
        this.description = description;
    }

    public Integer value(){
        return this.type;
    }
    public String getDescription() {
        return this.description;
    }

    public static String getModelDescription(int type){
        switch(type){
            case 0:
                return Merge_All.description;
            case 1 :
                return Split_By_Seller.description;
            case 2 :
                return Split_By_Purchaser.description;
            default :
                return "";
        }
    }
}
