package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RedflushSellerInvoiceRequest
 */

@JsonInclude(NON_NULL)
@Data
public class RedflushSellerInvoiceRequest {
  @ApiModelProperty(value = "可红冲发票id列表")
  private List<Long> invoiceIds = new ArrayList<Long>();
  @JsonProperty("deviceId")
  private Long deviceId = null;
  @JsonProperty("terminalId")
  @NotNull
  private Long terminalId;
  @JsonProperty("deviceUn")
  private String deviceUn;
  @JsonProperty("terminalUn")
  private String terminalUn;
  @ApiModelProperty(value = "开票模式, 1=单盘，2=服务器")
  @NotNull
  private String terminalType;
  @JsonProperty("tenantNo")
  private String tenantNo = null;
  @JsonProperty("companyId")
  private String companyId = null;
  @JsonProperty("nextInvoiceNo")
  private String nextInvoiceNo = null;
  @JsonProperty("nextInvoiceCode")
  private String nextInvoiceCode = null;
  @JsonProperty("invoicerName")
  private String invoicerName = null;
  @JsonProperty("redNotificationNo")
  private String redNotificationNo = null;
  @JsonProperty("releaseType")
  private Integer releaseType = null;
  @JsonProperty("reason")
  private String reason = null;
  @JsonProperty("customRedFlusReason")
  private String customRedFlusReason = null;
  private String makingReason = null;
  private String issuer = null;
  /**
   * 是否乐企标识（不传默认为false，如果传为true，走乐企通道）
   */
  private Boolean isNaturalSystemFlag;
  @JsonProperty("invoiceRedLetterMap")
  private Map<String, String> invoiceRedLetterMap = Maps.newHashMap();
  private Integer deployType = null;
  /**
   * 是否自动开具
   */
  private Boolean autoFlag;
  /**
   * 红冲时
   * 红冲票的发票类型
   */
  @JsonProperty("redflushInvoiceType")
  private String redflushInvoiceType = null;
  /**
   * 是否为 自动开具发起的红冲   AutoInvoiceFlag VIRTUAL = 2 为虚拟开具
   */
  @JsonProperty("autoInvoiceFlag")
  private Integer autoInvoiceFlag = null;
  private String operateType;
  /**
   * 系统来源
   */
  @JsonProperty("systemOrig")
  private String systemOrig = null;
  /**
   * 红票国税来源
   */
  @JsonProperty("redTaxInvoiceSource")
  private String redTaxInvoiceSource = null;
  /**
   * 自动申请红字
   */
  @JsonProperty("autoApply")
  private Integer autoApply = null;

  @ApiModelProperty("开具方式 issue-开具 issue_print-开具并打印  red_issue_print-红冲并打印")
  private String mode;

  private Boolean qdPassOperator;
}
