package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 查询条件
 */
@ApiModel(description = "查询条件")

@JsonInclude(NON_NULL)
public class RequestField {
  @JsonProperty("fieldName")
  private String fieldName = null;

  @JsonProperty("value")
  private List<String> value = new ArrayList<String>();

  @JsonProperty("fieldQueryType")
  private String fieldQueryType = null;

  @JsonProperty("virtual")
  private String virtual;

  @JsonProperty("filedType")
  private String filedType;

  public String getFiledType() {
    return filedType;
  }

  public void setFiledType(String filedType) {
    this.filedType = filedType;
  }

  @JsonIgnore
  public RequestField fieldName(String fieldName) {
    this.fieldName = fieldName;
    return this;
  }

  /**
   * 字段名
   * @return fieldName
   **/
  @ApiModelProperty(value = "字段名")
  public String getFieldName() {
    return fieldName;
  }

  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }

  @JsonIgnore
  public RequestField value(List<String> value) {
    this.value = value;
    return this;
  }

  public RequestField addValueItem(String valueItem) {
    this.value.add(valueItem);
    return this;
  }

  /**
   * 字段值
   * @return value
   **/
  @ApiModelProperty(value = "字段值")
  public List<String> getValue() {
    return value;
  }

  public void setValue(List<String> value) {
    this.value = value;
  }

  @JsonIgnore
  public RequestField fieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
    return this;
  }

  /**
   * 操作符
   * @return fieldQueryType
   **/
  @ApiModelProperty(value = "操作符")
  public String getFieldQueryType() {
    return fieldQueryType;
  }

  public void setFieldQueryType(String fieldQueryType) {
    this.fieldQueryType = fieldQueryType;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RequestField requestField = (RequestField) o;
    return Objects.equals(this.fieldName, requestField.fieldName) &&
            Objects.equals(this.value, requestField.value) &&
            Objects.equals(this.fieldQueryType, requestField.fieldQueryType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(fieldName, value, fieldQueryType);
  }

  @Override
  public String toString() {
    return "RequestField{" +
            "fieldName='" + fieldName + '\'' +
            ", value=" + value +
            ", fieldQueryType='" + fieldQueryType + '\'' +
            ", virtual='" + virtual + '\'' +
            '}';
  }

  public String getVirtual() {
    return virtual;
  }

  public void setVirtual(String virtual) {
    this.virtual = virtual;
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
