package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * RuleInfo
 */

@JsonInclude(NON_NULL)
public class RuleInfo {
  @JsonProperty("taxDeviceType")
  private Integer taxDeviceType = null;

  @JsonProperty("amountLimit")
  private Double amountLimit = null;

  @JsonProperty("itemOrder")
  private Integer itemOrder = null;

  @JsonProperty("priceCountChoose")
  private Integer priceCountChoose = null;

  @JsonProperty("cargoList")
  private Integer cargoList = null;

  @JsonProperty("maxRecord")
  private Integer maxRecord = null;

  @JsonProperty("invoiceMaxRecord")
  private Integer invoiceMaxRecord = null;

  @JsonProperty("splitAmountRule")
  private Integer splitAmountRule = null;

  @JsonProperty("isRoundNumber")
  private Integer isRoundNumber = null;

  @JsonProperty("splitField")
  private String splitField = null;

  @JsonProperty("invoiceRemark")
  private String invoiceRemark = null;

  @JsonIgnore
  public RuleInfo taxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
    return this;
  }

   /**
   * 税控设备类型
   * @return taxDeviceType
  **/
  @ApiModelProperty(value = "税控设备类型")
  public Integer getTaxDeviceType() {
    return taxDeviceType;
  }

  public void setTaxDeviceType(Integer taxDeviceType) {
    this.taxDeviceType = taxDeviceType;
  }

  @JsonIgnore
  public RuleInfo amountLimit(Double amountLimit) {
    this.amountLimit = amountLimit;
    return this;
  }

   /**
   * 开票限额
   * @return amountLimit
  **/
  @ApiModelProperty(value = "开票限额")
  public Double getAmountLimit() {
    return amountLimit;
  }

  public void setAmountLimit(Double amountLimit) {
    this.amountLimit = amountLimit;
  }

  @JsonIgnore
  public RuleInfo itemOrder(Integer itemOrder) {
    this.itemOrder = itemOrder;
    return this;
  }

   /**
   * 明细顺序
   * @return itemOrder
  **/
  @ApiModelProperty(value = "明细顺序")
  public Integer getItemOrder() {
    return itemOrder;
  }

  public void setItemOrder(Integer itemOrder) {
    this.itemOrder = itemOrder;
  }

  @JsonIgnore
  public RuleInfo priceCountChoose(Integer priceCountChoose) {
    this.priceCountChoose = priceCountChoose;
    return this;
  }

   /**
   * 单价数量选项
   * @return priceCountChoose
  **/
  @ApiModelProperty(value = "单价数量选项")
  public Integer getPriceCountChoose() {
    return priceCountChoose;
  }

  public void setPriceCountChoose(Integer priceCountChoose) {
    this.priceCountChoose = priceCountChoose;
  }

  @JsonIgnore
  public RuleInfo cargoList(Integer cargoList) {
    this.cargoList = cargoList;
    return this;
  }

   /**
   * 销货清单选项
   * @return cargoList
  **/
  @ApiModelProperty(value = "销货清单选项")
  public Integer getCargoList() {
    return cargoList;
  }

  public void setCargoList(Integer cargoList) {
    this.cargoList = cargoList;
  }

  @JsonIgnore
  public RuleInfo maxRecord(Integer maxRecord) {
    this.maxRecord = maxRecord;
    return this;
  }

   /**
   * 最大行
   * @return maxRecord
  **/
  @ApiModelProperty(value = "最大行")
  public Integer getMaxRecord() {
    return maxRecord;
  }

  public void setMaxRecord(Integer maxRecord) {
    this.maxRecord = maxRecord;
  }

  @JsonIgnore
  public RuleInfo invoiceMaxRecord(Integer invoiceMaxRecord) {
    this.invoiceMaxRecord = invoiceMaxRecord;
    return this;
  }

   /**
   * 票面最大行
   * @return invoiceMaxRecord
  **/
  @ApiModelProperty(value = "票面最大行")
  public Integer getInvoiceMaxRecord() {
    return invoiceMaxRecord;
  }

  public void setInvoiceMaxRecord(Integer invoiceMaxRecord) {
    this.invoiceMaxRecord = invoiceMaxRecord;
  }

  @JsonIgnore
  public RuleInfo splitAmountRule(Integer splitAmountRule) {
    this.splitAmountRule = splitAmountRule;
    return this;
  }

   /**
   * 拆分金额规则
   * @return splitAmountRule
  **/
  @ApiModelProperty(value = "拆分金额规则")
  public Integer getSplitAmountRule() {
    return splitAmountRule;
  }

  public void setSplitAmountRule(Integer splitAmountRule) {
    this.splitAmountRule = splitAmountRule;
  }

  @JsonIgnore
  public RuleInfo isRoundNumber(Integer isRoundNumber) {
    this.isRoundNumber = isRoundNumber;
    return this;
  }

   /**
   * 是否取整
   * @return isRoundNumber
  **/
  @ApiModelProperty(value = "是否取整")
  public Integer getIsRoundNumber() {
    return isRoundNumber;
  }

  public void setIsRoundNumber(Integer isRoundNumber) {
    this.isRoundNumber = isRoundNumber;
  }

  @JsonIgnore
  public RuleInfo splitField(String splitField) {
    this.splitField = splitField;
    return this;
  }

   /**
   * 拆分字段
   * @return splitField
  **/
  @ApiModelProperty(value = "拆分字段")
  public String getSplitField() {
    return splitField;
  }

  public void setSplitField(String splitField) {
    this.splitField = splitField;
  }

  @JsonIgnore
  public RuleInfo invoiceRemark(String invoiceRemark) {
    this.invoiceRemark = invoiceRemark;
    return this;
  }

   /**
   * 开票备注
   * @return invoiceRemark
  **/
  @ApiModelProperty(value = "开票备注")
  public String getInvoiceRemark() {
    return invoiceRemark;
  }

  public void setInvoiceRemark(String invoiceRemark) {
    this.invoiceRemark = invoiceRemark;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    RuleInfo ruleInfo = (RuleInfo) o;
    return Objects.equals(this.taxDeviceType, ruleInfo.taxDeviceType) &&
        Objects.equals(this.amountLimit, ruleInfo.amountLimit) &&
        Objects.equals(this.itemOrder, ruleInfo.itemOrder) &&
        Objects.equals(this.priceCountChoose, ruleInfo.priceCountChoose) &&
        Objects.equals(this.cargoList, ruleInfo.cargoList) &&
        Objects.equals(this.maxRecord, ruleInfo.maxRecord) &&
        Objects.equals(this.invoiceMaxRecord, ruleInfo.invoiceMaxRecord) &&
        Objects.equals(this.splitAmountRule, ruleInfo.splitAmountRule) &&
        Objects.equals(this.isRoundNumber, ruleInfo.isRoundNumber) &&
        Objects.equals(this.splitField, ruleInfo.splitField) &&
        Objects.equals(this.invoiceRemark, ruleInfo.invoiceRemark);
  }

  @Override
  public int hashCode() {
    return Objects.hash(taxDeviceType, amountLimit, itemOrder, priceCountChoose, cargoList, maxRecord, invoiceMaxRecord, splitAmountRule, isRoundNumber, splitField, invoiceRemark);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class RuleInfo {\n");

    sb.append("    taxDeviceType: ").append(toIndentedString(taxDeviceType)).append("\n");
    sb.append("    amountLimit: ").append(toIndentedString(amountLimit)).append("\n");
    sb.append("    itemOrder: ").append(toIndentedString(itemOrder)).append("\n");
    sb.append("    priceCountChoose: ").append(toIndentedString(priceCountChoose)).append("\n");
    sb.append("    cargoList: ").append(toIndentedString(cargoList)).append("\n");
    sb.append("    maxRecord: ").append(toIndentedString(maxRecord)).append("\n");
    sb.append("    invoiceMaxRecord: ").append(toIndentedString(invoiceMaxRecord)).append("\n");
    sb.append("    splitAmountRule: ").append(toIndentedString(splitAmountRule)).append("\n");
    sb.append("    isRoundNumber: ").append(toIndentedString(isRoundNumber)).append("\n");
    sb.append("    splitField: ").append(toIndentedString(splitField)).append("\n");
    sb.append("    invoiceRemark: ").append(toIndentedString(invoiceRemark)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
