package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SaveSellerInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class SaveSellerInvoiceRequest {
  @JsonProperty("sellerInvoiceList")
  private List<SellerInvoiceInfo> sellerInvoiceList = new ArrayList<SellerInvoiceInfo>();

  @JsonIgnore
  public SaveSellerInvoiceRequest sellerInvoiceList(List<SellerInvoiceInfo> sellerInvoiceList) {
    this.sellerInvoiceList = sellerInvoiceList;
    return this;
  }

  public SaveSellerInvoiceRequest addSellerInvoiceListItem(SellerInvoiceInfo sellerInvoiceListItem) {
    this.sellerInvoiceList.add(sellerInvoiceListItem);
    return this;
  }

   /**
   * 发票信息列表
   * @return sellerInvoiceList
  **/
  @ApiModelProperty(value = "发票信息列表")
  public List<SellerInvoiceInfo> getSellerInvoiceList() {
    return sellerInvoiceList;
  }

  public void setSellerInvoiceList(List<SellerInvoiceInfo> sellerInvoiceList) {
    this.sellerInvoiceList = sellerInvoiceList;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SaveSellerInvoiceRequest saveSellerInvoiceRequest = (SaveSellerInvoiceRequest) o;
    return Objects.equals(this.sellerInvoiceList, saveSellerInvoiceRequest.sellerInvoiceList);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sellerInvoiceList);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SaveSellerInvoiceRequest {\n");

    sb.append("    sellerInvoiceList: ").append(toIndentedString(sellerInvoiceList)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
