package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 销项发票对象--包含发票详情信息、发票明细列表信息
 */
@ApiModel(description = "发票详情--包含发票详情信息、发票明细列表信息")

@JsonInclude(NON_NULL)
public class SellerInvoice {
  @JsonProperty("invoiceInfo")
  private SellerInvoiceInfo invoiceInfo = null;

  @JsonProperty("invoiceDetails")
  private List<InvoiceItem> invoiceDetails = new ArrayList<InvoiceItem>();

  @JsonIgnore
  public SellerInvoice invoiceInfo(SellerInvoiceInfo invoiceInfo) {
    this.invoiceInfo = invoiceInfo;
    return this;
  }

   /**
   * 发票主信息
   * @return invoiceInfo
  **/
  @ApiModelProperty(value = "发票主信息")
  public SellerInvoiceInfo getInvoiceInfo() {
    return invoiceInfo;
  }

  public void setInvoiceInfo(SellerInvoiceInfo invoiceInfo) {
    this.invoiceInfo = invoiceInfo;
  }

  @JsonIgnore
  public SellerInvoice invoiceDetails(List<InvoiceItem> invoiceDetails) {
    this.invoiceDetails = invoiceDetails;
    return this;
  }

  public SellerInvoice addInvoiceDetails(InvoiceItem invoiceDetails) {
    this.invoiceDetails.add(invoiceDetails);
    return this;
  }

   /**
   * 发票明细列表
   * @return invoiceDetails
  **/
  @ApiModelProperty(value = "发票明细列表")
  public List<InvoiceItem> getInvoiceDetails() {
    return invoiceDetails;
  }

  public void setInvoiceDetails(List<InvoiceItem> invoiceDetails) {
    this.invoiceDetails = invoiceDetails;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    SellerInvoice invoiceDetails = (SellerInvoice) o;
    return Objects.equals(this.invoiceInfo, invoiceDetails.invoiceInfo) &&
        Objects.equals(this.invoiceDetails, invoiceDetails.invoiceDetails);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceInfo, invoiceDetails);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class SellerInvoice {\n");

    sb.append("    invoiceInfo: ").append(toIndentedString(invoiceInfo)).append("\n");
    sb.append("    invoiceDetails: ").append(toIndentedString(invoiceDetails)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
