package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * SellerInvoiceQueryByConditionRequest
 */

@JsonInclude(NON_NULL)
@Data
public class SellerInvoiceQueryByConditionRequest {
  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("userRole")
  private Integer userRole = null;

  @JsonProperty("sort")
  private Sort sort = null;

  /**
   * sortList有值时，优先取sortList
   */
  private List<Sort> sortList = null;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  private String requestSource;

  private Boolean queryWithAuth = true;

  private Boolean completionFields = true;

  private Boolean isMerchantQuery = false;

  private List<String> esInvoiceFilterFields;

  private Boolean ignoreTokenTenant = false;

  @ApiModelProperty("内部参数，不对外部开放")
  private Integer originGroupsSize = 0;

}
