package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@ApiModel(description = "预制发票查询结果")
public class SellerPreInvoiceRequest {

    @JsonProperty("salesbillId")
    @ApiModelProperty(value = "业务单id")
    private Long salesbillId = null;

    public Long getSalesbillId() {
        return salesbillId;
    }

    public void setSalesbillId(Long salesbillId) {
        this.salesbillId = salesbillId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SellerPreInvoiceRequest that = (SellerPreInvoiceRequest) o;
        return Objects.equals(salesbillId, that.salesbillId);
    }

    @Override
    public int hashCode() {

        return Objects.hash(salesbillId);
    }

    @Override
    public String toString() {
        return "SellerPreInvoiceRequest{" +
                "salesbillId=" + salesbillId +
                '}';
    }
}
