package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 按匹配度返回查询的发票信息
 */
@Data
public class SmartMatchInvoiceRequest implements Serializable {
    @ApiModelProperty(value = "单据/预制发票主键")
    @JsonProperty("id")
    private Long id;

    @ApiModelProperty(value = "销方租户ID，协同场景下需要传")
    @JsonProperty("sellerGroupId")
    private Long sellerGroupId;

    @ApiModelProperty(value = "明细主键")
    @JsonProperty("itemIdList")
    private List<Long> itemIdList;

    @ApiModelProperty(value = "开票日期范围")
    @JsonProperty("rangeTimes")
    private List<Long> rangeTimes;

    @ApiModelProperty(value = "发票票种集合")
    @JsonProperty("invoiceKindList")
    private List<String> invoiceKindList;

    @ApiModelProperty(value = "认证状态集合")
    @JsonProperty("identifyStatusList")
    private List<String> identifyStatusList;

    @ApiModelProperty(value = "请求来源")
    @JsonProperty("requestSource")
    private String requestSource;

//    @ApiModelProperty(value = "预匹配的发票id-")
//    @JsonProperty("invoiceId")
//    private Long invoiceId;

    @ApiModelProperty(value = "预匹配的发票idList")
    @JsonProperty("invoiceIdList")
    private List<Long> invoiceIdList;

}
