package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 排序字段
 */
@ApiModel(description = "排序字段")

@JsonInclude(NON_NULL)
public class SortField {
    @JsonProperty("propertyName")
    private String propertyName = null;

    @JsonProperty("order")
    private Integer order = null;

    @JsonIgnore
    public SortField propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    /**
     * 排序字段名
     *
     * @return propertyName
     **/
    @ApiModelProperty(value = "排序字段名")
    public String getPropertyName() {
        return propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    @JsonIgnore
    public SortField order(Integer order) {
        this.order = order;
        return this;
    }

    /**
     * 类型,0=升序，1=降序
     *
     * @return order
     **/
    @ApiModelProperty(value = "类型,0=升序，1=降序")
    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }


    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SortField sortField = (SortField) o;
        return Objects.equals(this.propertyName, sortField.propertyName) &&
                Objects.equals(this.order, sortField.order);
    }

    @Override
    public int hashCode() {
        return Objects.hash(propertyName, order);
    }


    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SortField {\n");

        sb.append("    propertyName: ").append(toIndentedString(propertyName)).append("\n");
        sb.append("    order: ").append(toIndentedString(order)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

}
