package com.xforceplus.seller.invoice.client.model;

import com.xforceplus.xplatframework.apimodel.BaseResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.ApiModelProperty;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/1 22:22
 */
public class SplitPreInvoiceResponse  extends BaseResponse {


    /**
     * 请求流水号
     */
    @ApiModelProperty("拆票任务id")
    private Long taskId;

    public SplitPreInvoiceResponse fail(String message){
        this.setMessage(message);
        this.taskId = 0L;
        this.setCode(Response.Fail);
        return this;
    }

    public SplitPreInvoiceResponse ok(long requestSerialNo){
        this.setCode(Response.OK);
        this.taskId = requestSerialNo;
        return this;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }
}
