package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
public class TerminalRequest {


    @ApiModelProperty(value = "设备唯一编码")
    private String deviceUn;
    @ApiModelProperty(value = "终端唯一编码")
    private String terminalUn;

    public String getDeviceUn() {
        return deviceUn;
    }

    public void setDeviceUn(String deviceUn) {
        this.deviceUn = deviceUn;
    }
    public String getTerminalUn() {
        return terminalUn;
    }

    public void setTerminalUn(String terminalUn) {
        this.terminalUn = terminalUn;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof TerminalRequest)) return false;
        TerminalRequest that = (TerminalRequest) o;
        return Objects.equals(getTerminalUn(), that.getTerminalUn());
    }

    @Override
    public int hashCode() {
        return Objects.hash(getTerminalUn());
    }
}
