package com.xforceplus.seller.invoice.client.model;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.NotNull;

@ApiModel("更新预制发票信息")
@JsonInclude(NON_NULL)
public class UpdatePreInvoicesRequest {

    @JsonProperty("preInvoiceId")
    @ApiModelProperty("预制发票 id")
    @NotNull(message = "预制发票 id不能为空!")
    private String preInvoiceId;

    @JsonProperty("originalAllElectricInvoiceNo")
    private String originalAllElectricInvoiceNo;

    @JsonProperty("originalInvoiceNo")
    private String originalInvoiceNo;

    @JsonProperty("originalInvoiceCode")
    private String originalInvoiceCode;

    @JsonProperty("originalInvoiceType")
    private String originalInvoiceType;

    @JsonProperty("originalDateIssued")
    private String originalDateIssued;

    @JsonProperty("redLetterNumber")
    private String redLetterNumber;

    @JsonProperty("remark")
    private String remark;

    public String getPreInvoiceId() {
        return preInvoiceId == null ? null : preInvoiceId.trim();
    }

    public void setPreInvoiceId(String preInvoiceId) {
        this.preInvoiceId = preInvoiceId == null ? null : preInvoiceId.trim();
    }

    public String getOriginalAllElectricInvoiceNo() {
        return originalAllElectricInvoiceNo == null ? null : originalAllElectricInvoiceNo.trim();
    }

    public void setOriginalAllElectricInvoiceNo(String originalAllElectricInvoiceNo) {
        this.originalAllElectricInvoiceNo =
            originalAllElectricInvoiceNo == null ? null : originalAllElectricInvoiceNo.trim();
    }

    public String getOriginalInvoiceNo() {
        return originalInvoiceNo == null ? null : originalInvoiceNo.trim();
    }

    public void setOriginalInvoiceNo(String originalInvoiceNo) {
        this.originalInvoiceNo = originalInvoiceNo == null ? null : originalInvoiceNo.trim();
    }

    public String getOriginalInvoiceCode() {
        return originalInvoiceCode == null ? null : originalInvoiceCode.trim();
    }

    public void setOriginalInvoiceCode(String originalInvoiceCode) {
        this.originalInvoiceCode = originalInvoiceCode == null ? null : originalInvoiceCode.trim();
    }

    public String getOriginalInvoiceType() {
        return originalInvoiceType == null ? null : originalInvoiceType.trim();
    }

    public void setOriginalInvoiceType(String originalInvoiceType) {
        this.originalInvoiceType = originalInvoiceType == null ? null : originalInvoiceType.trim();
    }

    public String getOriginalDateIssued() {
        return originalDateIssued == null ? null : originalDateIssued.trim();
    }

    public void setOriginalDateIssued(String originalDateIssued) {
        this.originalDateIssued = originalDateIssued == null ? null : originalDateIssued.trim();
    }

    public String getRedLetterNumber() {
        return redLetterNumber == null ? null : redLetterNumber.trim();
    }

    public void setRedLetterNumber(String redLetterNumber) {
        this.redLetterNumber = redLetterNumber == null ? null : redLetterNumber.trim();
    }

    public String getRemark() {
        return remark == null ? null : remark.trim();
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }
}
