package com.xforceplus.seller.invoice.client.model;

import java.util.Arrays;

public enum UserRole {
    PURCHASER("2", "购方"),
    SELLER("1", "销方");

    private final String userRole;
    private String description;

    private UserRole(String userRole, String description) {
        this.userRole = userRole;
        this.description = description;
    }

    public String value() {
        return this.userRole;
    }

    public static UserRole fromValue(String value) {
        return (UserRole) Arrays.stream(values()).filter((s) -> {
            return s.value().equals(value);
        }).findAny().orElseThrow(() -> {
            return new RuntimeException("购、销方类型错误.");
        });
    }
}
