package com.xforceplus.seller.invoice.client.model.ant;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * GetErrorCollectionResponse
 */
@ApiModel(description = "GetErrorCollectionResponse")

@JsonInclude(NON_NULL)
public class MsGetErrorCollectionResponse{
  @JsonProperty("code")
  private Integer code = null;

  @JsonProperty("message")
  private String message = null;

  @JsonProperty("total")
  private Long total = null;

  @JsonProperty("result")
  private List<MsErrorCollectionModel> result = new ArrayList<MsErrorCollectionModel>();

  @JsonIgnore
  public MsGetErrorCollectionResponse code(Integer code) {
    this.code = code;
    return this;
  }

   /**
   * 处理状态 0-失败 1-成功 2-处理中
   * @return code
  **/
  @ApiModelProperty(value = "处理状态 0-失败 1-成功 2-处理中")
  public Integer getCode() {
    return code;
  }

  public void setCode(Integer code) {
    this.code = code;
  }

  @JsonIgnore
  public MsGetErrorCollectionResponse message(String message) {
    this.message = message;
    return this;
  }

   /**
   * Get message
   * @return message
  **/
  @ApiModelProperty(value = "")
  public String getMessage() {
    return message;
  }

  public void setMessage(String message) {
    this.message = message;
  }

  @JsonIgnore
  public MsGetErrorCollectionResponse total(Long total) {
    this.total = total;
    return this;
  }

   /**
   * 总数
   * @return total
  **/
  @ApiModelProperty(value = "总数")
  public Long getTotal() {
    return total;
  }

  public void setTotal(Long total) {
    this.total = total;
  }

  @JsonIgnore
  public MsGetErrorCollectionResponse result(List<MsErrorCollectionModel> result) {
    this.result = result;
    return this;
  }

  public MsGetErrorCollectionResponse addResultItem(MsErrorCollectionModel resultItem) {
    this.result.add(resultItem);
    return this;
  }

   /**
   * 数据
   * @return result
  **/
  @ApiModelProperty(value = "数据")
  public List<MsErrorCollectionModel> getResult() {
    return result;
  }

  public void setResult(List<MsErrorCollectionModel> result) {
    this.result = result;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetErrorCollectionResponse getErrorCollectionResponse = (MsGetErrorCollectionResponse) o;
    return Objects.equals(this.code, getErrorCollectionResponse.code) &&
        Objects.equals(this.message, getErrorCollectionResponse.message) &&
        Objects.equals(this.total, getErrorCollectionResponse.total) &&
        Objects.equals(this.result, getErrorCollectionResponse.result);
  }

  @Override
  public int hashCode() {
    return Objects.hash(code, message, total, result);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetErrorCollectionResponse {\n");
    
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    total: ").append(toIndentedString(total)).append("\n");
    sb.append("    result: ").append(toIndentedString(result)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
