package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@ApiModel("申请红字信息明细金额相关")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class ApplyRedLetterDetail2 {
    @ApiModelProperty("不含税金额")
    @NotNull(message = "amountWithoutTax参数为必填项")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty("税额")
    @NotNull(message = "taxAmount参数为必填项")
    private BigDecimal taxAmount;

    @ApiModelProperty("税率")
    @NotNull(message = "taxRate参数为必填项")
    private String taxRate;

    @ApiModelProperty("数量")
    private BigDecimal quantity;

    @ApiModelProperty("扣除额")
    private BigDecimal deduction;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;


    @ApiModelProperty("货物或应税劳务编码（税编）")
    private String itemCode;

    @ApiModelProperty("货物或应税劳务名称")
    @NotNull(message = "itemName参数为必填项")
    private String itemName;

    @ApiModelProperty("规格型号")
    private String specifications;

    @ApiModelProperty("单位")
    private String unit;


    @ApiModelProperty("税收分类编码")
    @NotNull(message = "goodsTaxNo参数为必填项")
    private String goodsTaxNo;

    @ApiModelProperty("税编版本编号")
    private String goodsTaxNoVersion;

    @ApiModelProperty("是否享受税收优惠政策")
    private String taxPre;

    @ApiModelProperty("享受税收优惠政策内容")
    private String taxPreCon;

    @ApiModelProperty("零税率标识")
    private String zeroTax;

}
