package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("明细金额信息")
public class DetailAmount {
    @ApiModelProperty("数量")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal quantity;
    @ApiModelProperty("含税单价")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal unitPriceWithTax;
    @ApiModelProperty("不含税单价")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal unitPrice;
    @ApiModelProperty("含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithTax;
    @ApiModelProperty("不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal amountWithoutTax;
    @ApiModelProperty("税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal taxAmount;
    @ApiModelProperty("税率0.13?,0.09?,0.06?,0.05?,0.03?,0.00?,0.01")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal taxRate;
    @ApiModelProperty("扣除额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal deduction;
}
