package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("销项预制发票折扣")
public class DetailDiscount {
    @ApiModelProperty("明细折扣不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal discountWithoutTax;
    @ApiModelProperty("明细折扣含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal discountWithTax;
    @ApiModelProperty("明细折扣税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private BigDecimal discountTax;
}
