package com.xforceplus.seller.invoice.client.model.open;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

@ApiModel("金额信息")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class InvoiceAmount {
    @ApiModelProperty("含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @NotNull(message = "amountWithTax参数为必填项")
    private BigDecimal amountWithTax;
    @ApiModelProperty("不含税金额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @NotNull(message = "amountWithoutTax参数为必填项")
    private BigDecimal amountWithoutTax;
    @ApiModelProperty("税额")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    @NotNull(message = "taxAmount参数为必填项")
    private BigDecimal taxAmount;
    @ApiModelProperty("税率")
    private String taxRate;
}
