package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.*;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.List;

@ApiModel("开放接口申请红字信息请求")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OpenApplyRedLetterRequest {
    @ApiModelProperty("终端信息")
    @NotNull(message = "terminal参数为必填项")
    @Valid
    private OperatingTerminal terminal;
    @ApiModelProperty("红字信息集合")
    @Valid
    private List<ApplyRedLetterHead> redLetters;

    @ApiModelProperty("是否允许重试,默认：false。为 true 时，当流水号和已有的重复时，会以已有的红字确认单申请内容继续申请")
    private Boolean retryFlag = false;
}
