package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

@ApiModel("开放接口申请红字信息请求")
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class OpenApplyRedLetterV2Request {

    @ApiModelProperty("终端唯一码")
    private String terminalUn;

    @ApiModelProperty("设备唯一码")
    @NotNull(message = "deviceUn参数为必填项")
    private String deviceUn;

    @ApiModelProperty("账户类型: AR 或 AP")
    @NotNull(message = "accountType参数为必填项")
    private String accountType;

    @ApiModelProperty("红字信息集合")
    @Valid
    private ApplyRedLetterHead2 redLetter;

    @ApiModelProperty("是否允许重试,默认：false。为 true 时，当流水号和已有的重复时，会以已有的红字确认单申请内容继续申请")
    private Boolean retryFlag = false;
}
