package com.xforceplus.seller.invoice.client.model.open;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 根据 发票、号码(对应发票信息生成预制发票）批量红冲发票
 */
@Data
public class OpenBatchIssueHCRequest {
    /**
     * 释放类型 1-释放预制发票 2-释放业务单 3-不释放预制发票或业务单 4-释放业务单[释放业务单 但是 不释放 明细（抽取已匹配业务单的发票 释放情况）]
     */
    private Integer releaseType;
    /**
     * 开票终端
     */
    private String terminalNo;
    /**
     * 开具原因 参考枚举 MakingReason
     */
    private String reverseReason;
    /**
     * 原因
     */
    private String remark;

    @NotEmpty(message = "请传入原蓝发票信息")
    @Valid
    private List<ReverseInvoiceSummary> invoices;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class ReverseInvoiceSummary {
        /**
         * 发票号码，必填
         */
        @NotNull(message = "发票号码[invoiceNo]不能为空")
        @NotBlank(message = "发票号码[invoiceNo]不能为空字符串")
        private String invoiceNo;

        /**
         * 发票代码
         */
        @NotNull(message = "发票代码[invoiceCode]不能为空")
        @NotBlank(message = "发票代码[invoiceNo]不能为空字符串")
        private String invoiceCode;

        /**
         * 红字信息表 专票必填
         */
        private String redLetterNumber;
    }

}
