package com.xforceplus.seller.invoice.client.model.open;

import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("openapi返回结果")
public class OpenResponse<T> {
    private String code;
    private String message;
    private T result;
    private List<ErrorData> errors;

    public OpenResponse(T result) {
        this.code = "1";
        this.message = "";
        this.result = result;
        this.errors = null;
    }

    public OpenResponse(ErrorData error) {
        this.code = "0";
        this.message = "";
        this.result = null;
        this.errors = Lists.newArrayList(error);
    }

    public OpenResponse(List<ErrorData> errorDataList) {
        this.code = "0";
        this.message = "";
        this.result = null;
        this.errors = errorDataList;
    }
}
