package com.xforceplus.seller.invoice.client.model.open;

import io.swagger.annotations.ApiModel;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;

/**
 eq：等于（equal to）
 like：
 gt：大于（greater than）
 ge：大于等于（greater than or equal to）
 lt：小于（less than）
 le：小于等于（less than or equal to）
 ne：不等于（not equal to）
 range: 范围 前闭后闭
 */
@ApiModel(description = "查询类型")
@RequiredArgsConstructor
public enum Operator {
    eq("EqualTo"),
    like("Like"),
    range("Between"),
    in("In"),
    not_in("NotIn"),
    gt("GreaterThan"),
    ge("GreaterThanOrEqualTo"),
    lt("LessThan"),
    le("LessThanOrEqualTo"),
    ne("NotEqualTo");

    @Getter
    private final String value;

    public static boolean isValid(String name){
        if (StringUtils.isEmpty(name)){
            return false ;
        }
        return Arrays.stream(Operator.values()).anyMatch((item -> item.name().endsWith(name)));
    }

    public static Operator  getEnumByName(String name){
        for (Operator value : Operator.values()) {
            if (value.name().equalsIgnoreCase(name)){
                return value;
            }
        }
        return null ;
    }





}