package com.xforceplus.seller.invoice.client.model.redNotification;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description = "红字信息协同结果回填请求类")
@Getter
@Setter
public class RedNotificationCooperationBackFillRequest {

    @ApiModelProperty(value = "红字信息编号")
    @Size(min = 16, max = 16, message = "红字信息编号必须为16位")
    @NotBlank(message = "红字信息编号不能为空")
    private String redNotificationNo;

    @ApiModelProperty(value = "回填结果：0 失败，1 成功")
    @NotNull(message = "回填结果不能为空")
    private Integer status;

    @ApiModelProperty(value = "失败状态码")
    @Size(max = 16, message = "失败状态码最大长度为16")
    private String failCode;

    @ApiModelProperty(value = "失败原因")
    @Size(max = 500, message = "失败原因最大长度为500")
    private String failMessage;

}
