package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;


@ApiModel(
        description = "经办人"
)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class OperatorInfo {
    @JsonProperty("drawerName")
    private String drawerName = null;
    @JsonProperty("checkerName")
    private String checkerName = null;
    @JsonProperty("cashierName")
    private String cashierName = null;

    public OperatorInfo() {
    }

    public OperatorInfo(String drawerName, String checkerName, String cashierName) {
        this.drawerName = drawerName;
        this.checkerName = checkerName;
        this.cashierName = cashierName;
    }

    @JsonIgnore
    public OperatorInfo drawerName(String drawerName) {
        this.drawerName = drawerName;
        return this;
    }

    @ApiModelProperty("开票人")
    public String getDrawerName() {
        return this.drawerName;
    }

    public void setDrawerName(String drawerName) {
        this.drawerName = drawerName;
    }

    @JsonIgnore
    public OperatorInfo checkerName(String checkerName) {
        this.checkerName = checkerName;
        return this;
    }

    @ApiModelProperty("复核人")
    public String getCheckerName() {
        return this.checkerName;
    }

    public void setCheckerName(String checkerName) {
        this.checkerName = checkerName;
    }

    @JsonIgnore
    public OperatorInfo cashierName(String cashierName) {
        this.cashierName = cashierName;
        return this;
    }

    @ApiModelProperty("收款人")
    public String getCashierName() {
        return this.cashierName;
    }

    public void setCashierName(String cashierName) {
        this.cashierName = cashierName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OperatorInfo that = (OperatorInfo) o;
        return Objects.equals(drawerName, that.drawerName) &&
                Objects.equals(checkerName, that.checkerName) &&
                Objects.equals(cashierName, that.cashierName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(drawerName, checkerName, cashierName);
    }

    @Override
    public String toString() {
        return "AutoPdfOperatorInfo{" +
                "invoiceName='" + drawerName + '\'' +
                ", checkerName='" + checkerName + '\'' +
                ", cashierName='" + cashierName + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}
