package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
    description = "发票明细商品或劳务信息"
)
public class ProductionInfo {

    @JsonProperty("productionCode")
    private String productionCode = null;
    @JsonProperty("productionName")
    private String productionName = null;
    @JsonProperty("specification")
    private String specification = null;
    @JsonProperty("unitName")
    private String unitName = null;

    public ProductionInfo(String productionCode, String productionName, String specification, String unitName) {
        this.productionCode = productionCode;
        this.productionName = productionName;
        this.specification = specification;
        this.unitName = unitName;
    }

    public ProductionInfo() {
    }

    @JsonIgnore
    public ProductionInfo productionName(String productionName) {
        this.productionName = productionName;
        return this;
    }

    @ApiModelProperty("货物或应税劳务名称")
    public String getProductionName() {
        return this.productionName;
    }

    public void setProductionName(String productionName) {
        this.productionName = productionName;
    }

    @JsonIgnore
    public ProductionInfo productionCode(String productionCode) {
        this.productionCode = productionCode;
        return this;
    }

    @ApiModelProperty("货物或应税劳务编码(税编)")
    public String getProductionCode() {
        return this.productionCode;
    }

    public void setProductionCode(String productionCode) {
        this.productionCode = productionCode;
    }

    @JsonIgnore
    public ProductionInfo specification(String specification) {
        this.specification = specification;
        return this;
    }

    @ApiModelProperty("规格型号")
    public String getSpecification() {
        return this.specification;
    }

    public void setSpecification(String specification) {
        this.specification = specification;
    }

    @JsonIgnore
    public ProductionInfo unitName(String unitName) {
        this.unitName = unitName;
        return this;
    }

    @ApiModelProperty("单位")
    public String getUnitName() {
        return this.unitName;
    }

    public void setUnitName(String unitName) {
        this.unitName = unitName;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProductionInfo that = (ProductionInfo) o;
        return Objects.equals(productionCode, that.productionCode) &&
                Objects.equals(productionName, that.productionName) &&
                Objects.equals(specification, that.specification) &&
                Objects.equals(unitName, that.unitName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(productionCode, productionName, specification, unitName);
    }

    @Override
    public String toString() {
        return "ProductionInfo{" +
                "productionCode='" + productionCode + '\'' +
                ", productionName='" + productionName + '\'' +
                ", specification='" + specification + '\'' +
                ", unitName='" + unitName + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
