package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Objects;

@ApiModel(
        description = "结果"
)
public class ResultInfo {
    @JsonProperty("serialNo")
    private String serialNo = null;
    @JsonProperty("invoices")
    private List<InvoiceInfo> invoices;

    public ResultInfo(String serialNo, List<InvoiceInfo> invoices) {
        this.serialNo = serialNo;
        this.invoices = invoices;
    }

    public ResultInfo() {
    }

    @ApiModelProperty("流水号")
    public String getSerialNo() {
        return serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    @ApiModelProperty("发票信息 当未收到底层结果时，接口返回发票列表为空。当部分收到底层结果时，仅返回有结果的发票。")
    public List<InvoiceInfo> getInvoices() {
        return invoices;
    }

    public void setInvoices(List<InvoiceInfo> invoices) {
        this.invoices = invoices;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ResultInfo that = (ResultInfo) o;
        return Objects.equals(serialNo, that.serialNo) &&
                Objects.equals(invoices, that.invoices);
    }

    @Override
    public int hashCode() {
        return Objects.hash(serialNo, invoices);
    }

    @Override
    public String toString() {
        return "ResultInfo{" +
                "serialNo='" + serialNo + '\'' +
                ", invoices=" + invoices +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
