package com.xforceplus.seller.invoice.clientl.v2.mode;


import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(
        description = "销方信息"
)
@JsonInclude(Include.NON_NULL)
public class SellerInfo {

    @JsonProperty("sellerAddress")
    private String sellerAddress = null;
    @JsonProperty("sellerBank")
    private String sellerBank = null;
    @JsonProperty("sellerBankAccount")
    private String sellerBankAccount = null;
    @JsonProperty("sellerName")
    private String sellerName = null;
    @JsonProperty("sellerTaxCode")
    private String sellerTaxCode = null;
    @JsonProperty("sellerTelNo")
    private String sellerTelNo = null;

    public SellerInfo(String sellerAddress, String sellerBank, String sellerBankAccount, String sellerName, String sellerTaxCode, String sellerTelNo) {
        this.sellerAddress = sellerAddress;
        this.sellerBank = sellerBank;
        this.sellerBankAccount = sellerBankAccount;
        this.sellerName = sellerName;
        this.sellerTaxCode = sellerTaxCode;
        this.sellerTelNo = sellerTelNo;
    }

    public SellerInfo() {
    }

    @JsonIgnore
    public SellerInfo sellerTaxCode(String sellerTaxCode) {
        this.sellerTaxCode = sellerTaxCode;
        return this;
    }

    @ApiModelProperty("销方税号")
    public String getSellerTaxCode() {
        return this.sellerTaxCode;
    }

    public void setSellerTaxCode(String sellerTaxCode) {
        this.sellerTaxCode = sellerTaxCode;
    }

    @JsonIgnore
    public SellerInfo sellerName(String sellerName) {
        this.sellerName = sellerName;
        return this;
    }

    @ApiModelProperty("销方名称")
    public String getSellerName() {
        return this.sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    @JsonIgnore
    public SellerInfo sellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
        return this;
    }

    @ApiModelProperty("销方地址")
    public String getSellerAddress() {
        return this.sellerAddress;
    }

    public void setSellerAddress(String sellerAddress) {
        this.sellerAddress = sellerAddress;
    }

    @JsonIgnore
    public SellerInfo sellerTelNo(String sellerTelNo) {
        this.sellerTelNo = sellerTelNo;
        return this;
    }

    @ApiModelProperty("销方电话")
    public String getSellerTelNo() {
        return this.sellerTelNo;
    }

    public void setSellerTelNo(String sellerTelNo) {
        this.sellerTelNo = sellerTelNo;
    }

    @JsonIgnore
    public SellerInfo sellerBank(String sellerBank) {
        this.sellerBank = sellerBank;
        return this;
    }

    @ApiModelProperty("销方开户行")
    public String getSellerBank() {
        return this.sellerBank;
    }

    public void setSellerBank(String sellerBank) {
        this.sellerBank = sellerBank;
    }

    @JsonIgnore
    public SellerInfo sellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
        return this;
    }

    @ApiModelProperty("销方开户行账号")
    public String getSellerBankAccount() {
        return this.sellerBankAccount;
    }

    public void setSellerBankAccount(String sellerBankAccount) {
        this.sellerBankAccount = sellerBankAccount;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SellerInfo that = (SellerInfo) o;
        return Objects.equals(sellerAddress, that.sellerAddress) &&
                Objects.equals(sellerBank, that.sellerBank) &&
                Objects.equals(sellerBankAccount, that.sellerBankAccount) &&
                Objects.equals(sellerName, that.sellerName) &&
                Objects.equals(sellerTaxCode, that.sellerTaxCode) &&
                Objects.equals(sellerTelNo, that.sellerTelNo);
    }

    @Override
    public int hashCode() {
        return Objects.hash(sellerAddress, sellerBank, sellerBankAccount, sellerName, sellerTaxCode, sellerTelNo);
    }

    @Override
    public String toString() {
        return "AutoPdfSellerInfo{" +
                "sellerAddress='" + sellerAddress + '\'' +
                ", sellerBank='" + sellerBank + '\'' +
                ", sellerBankAccount='" + sellerBankAccount + '\'' +
                ", sellerName='" + sellerName + '\'' +
                ", sellerTaxCode='" + sellerTaxCode + '\'' +
                ", sellerTelNo='" + sellerTelNo + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }
}

