package com.xforceplus.seller.invoice.clientl.v2.mode;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;


@ApiModel(
    description = "机动车信息- 机动车发票使用"
)
public class VehicleInfo {

    @JsonProperty("purchaserId")
    private String purchaserId = null;
    @JsonProperty("sellerNo")
    private String sellerNo = null;
    @JsonProperty("manufacturerName")
    private String manufacturerName = null;
    @JsonProperty("vehicleType")
    private String vehicleType = null;
    @JsonProperty("vehicleBrand")
    private String vehicleBrand = null;
    @JsonProperty("productionArea")
    private String productionArea = null;
    @JsonProperty("certificationNo")
    private String certificationNo = null;
    @JsonProperty("importCertificationNo")
    private String importCertificationNo = null;
    @JsonProperty("commodityInspectionNo")
    private String commodityInspectionNo = null;
    @JsonProperty("engineNo")
    private String engineNo = null;
    @JsonProperty("vehicleNo")
    private String vehicleNo = null;
    @JsonProperty("tonnage")
    private String tonnage = null;
    @JsonProperty("maxCapacity")
    private String maxCapacity = null;
    @JsonProperty("taxPaidProofNo")
    private String taxPaidProofNo = null;
    @JsonProperty("vehicleSellerTelNo")
    private String vehicleSellerTelNo = null;
    @JsonProperty("chargeTaxAuthorityName")
    private String chargeTaxAuthorityName = null;
    @JsonProperty("chargeTaxAuthorityCode")
    private String chargeTaxAuthorityCode = null;
    @JsonProperty("tax")
    private TaxInfo tax = null;

    public VehicleInfo(String purchaserId, String sellerNo, String manufacturerName, String vehicleType, String vehicleBrand, String productionArea, String certificationNo, String importCertificationNo, String commodityInspectionNo, String engineNo, String vehicleNo, String tonnage, String maxCapacity, String taxPaidProofNo, String vehicleSellerTelNo, String chargeTaxAuthorityName, String chargeTaxAuthorityCode, TaxInfo tax) {
        this.purchaserId = purchaserId;
        this.sellerNo = sellerNo;
        this.manufacturerName = manufacturerName;
        this.vehicleType = vehicleType;
        this.vehicleBrand = vehicleBrand;
        this.productionArea = productionArea;
        this.certificationNo = certificationNo;
        this.importCertificationNo = importCertificationNo;
        this.commodityInspectionNo = commodityInspectionNo;
        this.engineNo = engineNo;
        this.vehicleNo = vehicleNo;
        this.tonnage = tonnage;
        this.maxCapacity = maxCapacity;
        this.taxPaidProofNo = taxPaidProofNo;
        this.vehicleSellerTelNo = vehicleSellerTelNo;
        this.chargeTaxAuthorityName = chargeTaxAuthorityName;
        this.chargeTaxAuthorityCode = chargeTaxAuthorityCode;
        this.tax = tax;
    }

    public VehicleInfo() {
    }

    @JsonIgnore
    public VehicleInfo purchaserId(String purchaserId) {
        this.purchaserId = purchaserId;
        return this;
    }

    @ApiModelProperty("购买者身份证号")
    public String getPurchaserId() {
        return this.purchaserId;
    }

    public void setPurchaserId(String purchaserId) {
        this.purchaserId = purchaserId;
    }

    @JsonIgnore
    public VehicleInfo sellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
        return this;
    }

    @ApiModelProperty("门店号")
    public String getSellerNo() {
        return this.sellerNo;
    }

    public void setSellerNo(String sellerNo) {
        this.sellerNo = sellerNo;
    }

    @JsonIgnore
    public VehicleInfo manufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
        return this;
    }

    @ApiModelProperty("生产企业名称")
    public String getManufacturerName() {
        return this.manufacturerName;
    }

    public void setManufacturerName(String manufacturerName) {
        this.manufacturerName = manufacturerName;
    }

    @JsonIgnore
    public VehicleInfo vehicleType(String vehicleType) {
        this.vehicleType = vehicleType;
        return this;
    }

    @ApiModelProperty("车辆类型")
    public String getVehicleType() {
        return this.vehicleType;
    }

    public void setVehicleType(String vehicleType) {
        this.vehicleType = vehicleType;
    }

    @JsonIgnore
    public VehicleInfo vehicleBrand(String vehicleBrand) {
        this.vehicleBrand = vehicleBrand;
        return this;
    }

    @ApiModelProperty("车辆品牌")
    public String getVehicleBrand() {
        return this.vehicleBrand;
    }

    public void setVehicleBrand(String vehicleBrand) {
        this.vehicleBrand = vehicleBrand;
    }

    @JsonIgnore
    public VehicleInfo productionArea(String productionArea) {
        this.productionArea = productionArea;
        return this;
    }

    @ApiModelProperty("产地")
    public String getProductionArea() {
        return this.productionArea;
    }

    public void setProductionArea(String productionArea) {
        this.productionArea = productionArea;
    }

    @JsonIgnore
    public VehicleInfo certificationNo(String certificationNo) {
        this.certificationNo = certificationNo;
        return this;
    }

    @ApiModelProperty("机动车合格证编号")
    public String getCertificationNo() {
        return this.certificationNo;
    }

    public void setCertificationNo(String certificationNo) {
        this.certificationNo = certificationNo;
    }

    @JsonIgnore
    public VehicleInfo importCertificationNo(String importCertificationNo) {
        this.importCertificationNo = importCertificationNo;
        return this;
    }

    @ApiModelProperty("进口机动车合格证编号")
    public String getImportCertificationNo() {
        return this.importCertificationNo;
    }

    public void setImportCertificationNo(String importCertificationNo) {
        this.importCertificationNo = importCertificationNo;
    }

    @JsonIgnore
    public VehicleInfo commodityInspectionNo(String commodityInspectionNo) {
        this.commodityInspectionNo = commodityInspectionNo;
        return this;
    }

    @ApiModelProperty("商检单号")
    public String getCommodityInspectionNo() {
        return this.commodityInspectionNo;
    }

    public void setCommodityInspectionNo(String commodityInspectionNo) {
        this.commodityInspectionNo = commodityInspectionNo;
    }

    @JsonIgnore
    public VehicleInfo engineNo(String engineNo) {
        this.engineNo = engineNo;
        return this;
    }

    @ApiModelProperty("发动机号")
    public String getEngineNo() {
        return this.engineNo;
    }

    public void setEngineNo(String engineNo) {
        this.engineNo = engineNo;
    }

    @JsonIgnore
    public VehicleInfo vehicleNo(String vehicleNo) {
        this.vehicleNo = vehicleNo;
        return this;
    }

    @ApiModelProperty("车辆识别号")
    public String getVehicleNo() {
        return this.vehicleNo;
    }

    public void setVehicleNo(String vehicleNo) {
        this.vehicleNo = vehicleNo;
    }

    @JsonIgnore
    public VehicleInfo tonnage(String tonnage) {
        this.tonnage = tonnage;
        return this;
    }

    @ApiModelProperty("吨位")
    public String getTonnage() {
        return this.tonnage;
    }

    public void setTonnage(String tonnage) {
        this.tonnage = tonnage;
    }

    @JsonIgnore
    public VehicleInfo maxCapacity(String maxCapacity) {
        this.maxCapacity = maxCapacity;
        return this;
    }

    @ApiModelProperty("限乘人数")
    public String getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(String maxCapacity) {
        this.maxCapacity = maxCapacity;
    }

    @JsonIgnore
    public VehicleInfo taxPaidProofNo(String taxPaidProofNo) {
        this.taxPaidProofNo = taxPaidProofNo;
        return this;
    }

    @ApiModelProperty("完税凭证号码")
    public String getTaxPaidProofNo() {
        return this.taxPaidProofNo;
    }

    public void setTaxPaidProofNo(String taxPaidProofNo) {
        this.taxPaidProofNo = taxPaidProofNo;
    }

    @JsonIgnore
    public VehicleInfo vehicleSellerTelNo(String vehicleSellerTelNo) {
        this.vehicleSellerTelNo = vehicleSellerTelNo;
        return this;
    }

    @ApiModelProperty("机动车购方电话")
    public String getVehicleSellerTelNo() {
        return this.vehicleSellerTelNo;
    }

    public void setVehicleSellerTelNo(String vehicleSellerTelNo) {
        this.vehicleSellerTelNo = vehicleSellerTelNo;
    }

    @JsonIgnore
    public VehicleInfo chargeTaxAuthorityName(String chargeTaxAuthorityName) {
        this.chargeTaxAuthorityName = chargeTaxAuthorityName;
        return this;
    }

    @ApiModelProperty("主管税务机关名称")
    public String getChargeTaxAuthorityName() {
        return this.chargeTaxAuthorityName;
    }

    public void setChargeTaxAuthorityName(String chargeTaxAuthorityName) {
        this.chargeTaxAuthorityName = chargeTaxAuthorityName;
    }

    @JsonIgnore
    public VehicleInfo chargeTaxAuthorityCode(String chargeTaxAuthorityCode) {
        this.chargeTaxAuthorityCode = chargeTaxAuthorityCode;
        return this;
    }

    @ApiModelProperty("主管税务机关代码")
    public String getChargeTaxAuthorityCode() {
        return this.chargeTaxAuthorityCode;
    }

    public void setChargeTaxAuthorityCode(String chargeTaxAuthorityCode) {
        this.chargeTaxAuthorityCode = chargeTaxAuthorityCode;
    }

    @JsonIgnore
    public VehicleInfo tax(TaxInfo tax) {
        this.tax = tax;
        return this;
    }

    @ApiModelProperty("税收信息")
    public TaxInfo getTaxInfo() {
        return this.tax;
    }

    public void setTaxInfo(TaxInfo tax) {
        this.tax = tax;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        VehicleInfo that = (VehicleInfo) o;
        return Objects.equals(purchaserId, that.purchaserId) &&
                Objects.equals(sellerNo, that.sellerNo) &&
                Objects.equals(manufacturerName, that.manufacturerName) &&
                Objects.equals(vehicleType, that.vehicleType) &&
                Objects.equals(vehicleBrand, that.vehicleBrand) &&
                Objects.equals(productionArea, that.productionArea) &&
                Objects.equals(certificationNo, that.certificationNo) &&
                Objects.equals(importCertificationNo, that.importCertificationNo) &&
                Objects.equals(commodityInspectionNo, that.commodityInspectionNo) &&
                Objects.equals(engineNo, that.engineNo) &&
                Objects.equals(vehicleNo, that.vehicleNo) &&
                Objects.equals(tonnage, that.tonnage) &&
                Objects.equals(maxCapacity, that.maxCapacity) &&
                Objects.equals(taxPaidProofNo, that.taxPaidProofNo) &&
                Objects.equals(vehicleSellerTelNo, that.vehicleSellerTelNo) &&
                Objects.equals(chargeTaxAuthorityName, that.chargeTaxAuthorityName) &&
                Objects.equals(chargeTaxAuthorityCode, that.chargeTaxAuthorityCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(purchaserId, sellerNo, manufacturerName, vehicleType, vehicleBrand, productionArea, certificationNo, importCertificationNo, commodityInspectionNo, engineNo, vehicleNo, tonnage, maxCapacity, taxPaidProofNo, vehicleSellerTelNo, chargeTaxAuthorityName, chargeTaxAuthorityCode);
    }

    @Override
    public String toString() {
        return "VehicleInfo{" +
                "purchaserId='" + purchaserId + '\'' +
                ", sellerNo='" + sellerNo + '\'' +
                ", manufacturerName='" + manufacturerName + '\'' +
                ", vehicleType='" + vehicleType + '\'' +
                ", vehicleBrand='" + vehicleBrand + '\'' +
                ", productionArea='" + productionArea + '\'' +
                ", certificationNo='" + certificationNo + '\'' +
                ", importCertificationNo='" + importCertificationNo + '\'' +
                ", commodityInspectionNo='" + commodityInspectionNo + '\'' +
                ", engineNo='" + engineNo + '\'' +
                ", vehicleNo='" + vehicleNo + '\'' +
                ", tonnage='" + tonnage + '\'' +
                ", maxCapacity='" + maxCapacity + '\'' +
                ", taxPaidProofNo='" + taxPaidProofNo + '\'' +
                ", vehicleSellerTelNo='" + vehicleSellerTelNo + '\'' +
                ", chargeTaxAuthorityName='" + chargeTaxAuthorityName + '\'' +
                ", chargeTaxAuthorityCode='" + chargeTaxAuthorityCode + '\'' +
                '}';
    }

    private String toIndentedString(Object o) {
        return o == null ? "null" : o.toString().replace("\n", "\n    ");
    }

}
