package com.xforceplus.seller.invoice.clientl.v2.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.clientl.v2.mode.ResultInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 *
 */
@ApiModel(description = "查询开票结果")

@JsonInclude(NON_NULL)
public class QueryMakeOutResultResponse {

    @JsonProperty("code")
    private String code;

    @JsonProperty("message")
    private String message;

    @JsonProperty("traceId")
    private String traceId;

    @JsonProperty("result")
    private ResultInfo result = null;

    public QueryMakeOutResultResponse(String code, String message, String traceId, ResultInfo result) {
        this.code = code;
        this.message = message;
        this.traceId = traceId;
        this.result = result;
    }

    public QueryMakeOutResultResponse() {
    }

    @JsonIgnore
    public QueryMakeOutResultResponse code(String code) {
        this.code = code;
        return this;
    }

    /**
     * Get code
     * @return code
     **/
    @ApiModelProperty("返回码 成功：TXWR000000 失败：非TXWR000000")
    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @JsonIgnore
    public QueryMakeOutResultResponse message(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get message
     * @return message
     **/
    @ApiModelProperty("信息描述")
    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @JsonIgnore
    public QueryMakeOutResultResponse traceId(String traceId) {
        this.traceId = traceId;
        return this;
    }

    /**
     * Get traceId
     * @return message
     **/
    @ApiModelProperty("信息描述")
    public String getTraceId() {
        return traceId;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    @JsonIgnore
    public QueryMakeOutResultResponse result(ResultInfo result) {
        this.result = result;
        return this;
    }

    /**
     * Get result
     * @return result
     **/
    @ApiModelProperty("结果")
    public ResultInfo getResult() {
        return result;
    }

    public void setResult(ResultInfo result) {
        this.result = result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        QueryMakeOutResultResponse that = (QueryMakeOutResultResponse) o;
        return Objects.equals(code, that.code) &&
                Objects.equals(message, that.message) &&
                Objects.equals(traceId, that.traceId) &&
                Objects.equals(result, that.result);
    }

    @Override
    public int hashCode() {
        return Objects.hash(code, message, traceId, result);
    }

    @Override
    public String toString() {
        return "QueryMakeOutResultResponse{" +
                "code='" + code + '\'' +
                ", message='" + message + '\'' +
                ", traceId='" + traceId + '\'' +
                ", result=" + result +
                '}';
    }

    /**
     * Convert the given object to string with each line indented by 4 spaces
     * (except the first line).
     */
    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}
