package com.xforceplus.seller.invoice.client.api;
import com.xforceplus.seller.invoice.client.model.SplitBillResponse;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Api(value = "Bill2PreInvoiceApi", description = "the Bill2PreInvoiceApi API")
public interface Bill2PreInvoiceApi {


    @ApiOperation(value = "获取拆票结果", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags = {"Bill2PreInvoiceApi",})
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SplitBillResponse.class)})
    @RequestMapping(method = RequestMethod.GET, path = "/getSplitBill", produces = MediaType.APPLICATION_JSON_VALUE)
    SplitBillResponse getSplitBill(@RequestParam Long txId);

}
