package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.SellerPreInvoiceQueryByConditionRequest;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Api(value = "preInvoiceDevOps", description = "the preInvoiceDevOps API")
public interface PreInvoiceDevOpsApi {

    @ApiOperation(value = "获取预制发票信息", notes = "", response = Response.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "PreInvoiceDevOps", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "response", response = Response.class) })
    @RequestMapping(value = "/getPreInvoiceInfo",
            produces = { "application/json" },
            method = RequestMethod.POST)
    Response getPreInvoiceInfo(@ApiParam(value = "request", required = true) @RequestBody SellerPreInvoiceQueryByConditionRequest request);

}
