package com.xforceplus.seller.invoice.client.api;

import com.xforceplus.seller.invoice.client.model.*;
import com.xforceplus.seller.invoice.client.model.open.v2.pre.UnIssuedPreinvoice;
import com.xforceplus.xplatframework.model.Response;
import io.swagger.annotations.*;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/1 22:21
 */
@Api(value = "Invoice", description = "the Invoice API")
public interface SplitApi {

    @ApiOperation(value = "拆票开具", notes = "", response = SplitPreInvoiceResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "Split", })
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = SplitPreInvoiceResponse.class) })
    @RequestMapping(value = "/split/pre-invoice",
            produces = {"application/json"},
            method = RequestMethod.POST)
    SplitPreInvoiceResponse splitAndMakeOut(@ApiParam(value = "拆票请求", required = true)  @RequestBody List<SplitPreInvoiceRequest> splitRequestList);

    @ApiOperation(value = "拆票预览", notes = "", response = SplitPreInvoiceResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "Split", })
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = SplitPreInvoiceResponse.class) })
    @RequestMapping(value = "/split/pre-invoice-view",
            produces = {"application/json"},
            method = RequestMethod.POST)
    Response<List<UnIssuedPreinvoice>> splitView(@ApiParam(value = "拆票请求", required = true) @RequestBody SplitPreInvoiceRequest splitRequestList);


    @ApiOperation(value = "查询拆票结果", notes = "", response = MsPollingSplitAndMakeOutResponse.class, authorizations = {
            @Authorization(value = "x-access-token")
    }, tags={ "Split", })
    @ApiResponses(value = {@ApiResponse(code = 200, message = "统一返回", response = MsPollingSplitAndMakeOutResponse.class) })
    @RequestMapping(value = "/split/query-split-result",
            produces = {"application/json"},
            method = RequestMethod.POST)
    MsPollingSplitAndMakeOutResponse querySplitResult(@ApiParam(value = "查询请求", required = true) @RequestBody MsPollingSplitAndMakeOutRequest request);

    /*
    @ApiOperation(value = "业务中台拆票结果返回", notes = "", response = SplitCallbackResponse.class, authorizations = {
            @Authorization(value = "X-Access-Token"),
            @Authorization(value = "X-Operation-Token")
    }, tags={ "Split", })
    @ApiResponses(value = {
            @ApiResponse(code = 200, message = "统一返回", response = SplitCallbackResponse.class) })
    @RequestMapping(value = "/split/splitResultCallback",
            produces = { "application/json" },
            method = RequestMethod.POST)
    SplitCallbackResponse splitResultCallback(@ApiParam(value = "结果参数"  ) @RequestBody SplitCallbackRequest splitCallbackRequest);
    */
}
