package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@ApiModel("预制发票申请红字信息请求")
@Data
public class ApplyRedLetterRequest implements Serializable {
    @ApiModelProperty("原发票号码")
    private String originInvoiceNo;
    @ApiModelProperty("原发票代码")
    private String originInvoiceCode;
    @ApiModelProperty("原发票类型")
    private String originInvoiceType;
    @ApiModelProperty("原开票日期")
    private String originPaperDrawDate;
    @ApiModelProperty("申请类型")
    private Integer applyType;
    @ApiModelProperty("设备唯一码")
    private String deviceUn;
    @ApiModelProperty("终端唯一码")
    private String terminalUn;
    @ApiModelProperty("用户角色")
    private String userRole;
    @ApiModelProperty("终端类型")
    private Integer terminalType;
    @ApiModelProperty("预制发票id")
    @JsonFormat(shape = JsonFormat.Shape.STRING)
    private Long preInvoiceId;
    @ApiModelProperty("特殊发票申请原因")
    private String specialInvoiceApplyReason;
    @ApiModelProperty("数电开票人")
    private String issuer;
    @ApiModelProperty("申请原因")
    private String applyReason;
    @ApiModelProperty("乐企标识")
    private Boolean isNaturalSystemFlag;

    public Long getPreInvoiceId() {
        return this.preInvoiceId;
    }
}