package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * BasePrintSellerInvoiceRequest
 */

@JsonInclude(NON_NULL)
public class BasePrintSellerInvoiceRequest {
  @JsonProperty("invoiceIdList")
  private List<Long> invoiceIdList = new ArrayList<Long>();

  @JsonProperty("terminalId")
  private Long terminalId = null;

  @JsonProperty("deviceId")
  private Long deviceId = null;

  @JsonProperty("deviceUn")
  private String deviceUn;

  @JsonProperty("terminalUn")
  private String terminalUn;

  @JsonProperty("printType")
  private String printType = null;

  @JsonProperty("supportService")
  private List<String> supportService = Lists.newArrayList();

  @JsonProperty("terminalType")
  private Integer terminalType = null;

  @JsonProperty("taskId")
  private Long  taskId = null;

  @JsonProperty("requestSource")
  private String  requestSource = null;

  public String getDeviceUn() {
    return deviceUn;
  }

  public void setDeviceUn(String deviceUn) {
    this.deviceUn = deviceUn;
  }

  public String getTerminalUn() {
    return terminalUn;
  }

  public void setTerminalUn(String terminalUn) {
    this.terminalUn = terminalUn;
  }

  @JsonIgnore
  public BasePrintSellerInvoiceRequest invoiceIdList(List<Long> invoiceIdList) {
    this.invoiceIdList = invoiceIdList;
    return this;
  }

  public BasePrintSellerInvoiceRequest addInvoiceIdListItem(Long invoiceIdListItem) {
    this.invoiceIdList.add(invoiceIdListItem);
    return this;
  }

   /**
   * 发票序列号主键列表
   * @return invoiceIdList
  **/
  @ApiModelProperty(value = "发票序列号主键列表")
  public List<Long> getInvoiceIdList() {
    return invoiceIdList;
  }

  public void setInvoiceIdList(List<Long> invoiceIdList) {
    this.invoiceIdList = invoiceIdList;
  }

  @JsonIgnore
  public BasePrintSellerInvoiceRequest terminalId(Long terminalId) {
    this.terminalId = terminalId;
    return this;
  }

   /**
   * 终端id
   * @return terminalId
  **/
  @ApiModelProperty(value = "终端id")
  public Long getTerminalId() {
    return terminalId;
  }

  public void setTerminalId(Long terminalId) {
    this.terminalId = terminalId;
  }

  @JsonIgnore
  public BasePrintSellerInvoiceRequest deviceId(Long deviceId) {
    this.deviceId = deviceId;
    return this;
  }

   /**
   * 设备id
   * @return deviceId
  **/
  @ApiModelProperty(value = "设备id")
  public Long getDeviceId() {
    return deviceId;
  }

  public void setDeviceId(Long deviceId) {
    this.deviceId = deviceId;
  }

  @JsonIgnore
  public BasePrintSellerInvoiceRequest printType(String printType) {
    this.printType = printType;
    return this;
  }

   /**
   * 打印类型
   * @return printType
  **/
  @ApiModelProperty(value = "打印类型")
  public String getPrintType() {
    return printType;
  }

  public void setPrintType(String printType) {
    this.printType = printType;
  }

  @ApiModelProperty(value = "服务类型")
  public List<String> getSupportService() {
    return supportService;
  }

  public void setSupportService(List<String> supportService) {
    this.supportService = supportService;
  }
  @ApiModelProperty(value = "终端类型")
  public Integer getTerminalType() {
    return terminalType;
  }

  public void setTerminalType(Integer terminalType) {
    this.terminalType = terminalType;
  }

  public Long getTaskId() {
    return taskId;
  }

  public void setTaskId(Long taskId) {
    this.taskId = taskId;
  }

  public String getRequestSource() {
    return requestSource;
  }

  public void setRequestSource(String requestSource) {
    this.requestSource = requestSource;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BasePrintSellerInvoiceRequest basePrintSellerInvoiceRequest = (BasePrintSellerInvoiceRequest) o;
    return Objects.equals(this.invoiceIdList, basePrintSellerInvoiceRequest.invoiceIdList) &&
        Objects.equals(this.terminalId, basePrintSellerInvoiceRequest.terminalId) &&
        Objects.equals(this.deviceId, basePrintSellerInvoiceRequest.deviceId) &&
        Objects.equals(this.printType, basePrintSellerInvoiceRequest.printType);
  }

  @Override
  public int hashCode() {
    return Objects.hash(invoiceIdList, terminalId, deviceId, printType);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BasePrintSellerInvoiceRequest {\n");

    sb.append("    invoiceIdList: ").append(toIndentedString(invoiceIdList)).append("\n");
    sb.append("    terminalId: ").append(toIndentedString(terminalId)).append("\n");
    sb.append("    deviceId: ").append(toIndentedString(deviceId)).append("\n");
    sb.append("    printType: ").append(toIndentedString(printType)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
