package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): wangjingshuang
 * 创建日期:      2020年3月20日09:20:16
 */
@ApiModel(description = "锁定单据和发票的匹配关系请求")

@JsonInclude(NON_NULL)
public class BillInvoiceLockMatchedRelationRequest {

    @JsonProperty("userRole")
    private Integer userRole = null;

    @ApiModelProperty(value = "锁定请求参数")
    @JsonProperty("billInvoiceMatchedRelationInfo")
    private BillInvoiceMatchedRelationInfo billInvoiceMatchedRelationInfo;

    public Integer getUserRole() {
        return userRole;
    }

    public void setUserRole(Integer userRole) {
        this.userRole = userRole;
    }

    public BillInvoiceMatchedRelationInfo getBillInvoiceMatchedRelationInfo() {
        return billInvoiceMatchedRelationInfo;
    }

    public void setBillInvoiceMatchedRelationInfo(BillInvoiceMatchedRelationInfo billInvoiceMatchedRelationInfo) {
        this.billInvoiceMatchedRelationInfo = billInvoiceMatchedRelationInfo;
    }
}
