package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;
import java.util.Map;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@ApiModel(description = "修改发票匹配的业务单号")
@JsonInclude(NON_NULL)
public class CompleteDrawInvoiceRequest {

    @JsonProperty("fieldToValueMap")
    private Map<String, String> fieldToValueMap;

    @JsonProperty("invoiceIds")
    private List<Long> invoiceIds;

    @ApiModelProperty(value = "更新键值对")
    public Map<String, String> getFieldToValueMap() {
        return fieldToValueMap;
    }

    public void setFieldToValueMap(Map<String, String> fieldToValueMap) {
        this.fieldToValueMap = fieldToValueMap;
    }

    @ApiModelProperty(value = "发票Ids")
    public List<Long> getInvoiceIds() {
        return invoiceIds;
    }

    public void setInvoiceIds(List<Long> invoiceIds) {
        this.invoiceIds = invoiceIds;
    }
}
