package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.ArrayList;
import java.util.List;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

@JsonInclude(NON_NULL)
@Data
public class ExportSellerInvoiceRequest {
  @JsonProperty("conditions")
  private Conditions conditions = null;

  @JsonProperty("isAllSelected")
  private Boolean isAllSelected = null;

  @JsonProperty("includes")
  private List<Long> includes = new ArrayList<Long>();

  @JsonProperty("excludes")
  private List<Long> excludes = new ArrayList<Long>();

  @JsonProperty("status")
  private Integer status = null;

  @JsonProperty("userRole")
  private Integer userRole = null;

  @JsonProperty("sort")
  private Sort sort = null;

  @ApiModelProperty("搜索查询范围")
  private List<Long> createTime;

  @JsonProperty("groups")
  private List<List<RequestField>> groups = new ArrayList<List<RequestField>>();

  @JsonProperty("queryWithAuth")
  private Boolean queryWithAuth=true;

  @JsonProperty("isMerchantQuery")
  private Boolean isMerchantQuery = false;

  private String requestSource;
}
