package com.xforceplus.seller.invoice.client.model;

import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 项目名称:
 * 模块名称:
 * 说明:
 * JDK 版本:      1.8
 * 作者(@author): chen cheng
 * 创建日期:      2019/8/25 18:09
 */
public class MakeOutFailInfo {

    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "预制发票id")
    private Long preInvoiceId;

    @ApiModelProperty(value = "业务单号")
    private String salesbillNo;

    @ApiModelProperty(value = "销方集团id")
    private Long sellerGroupId;

    @ApiModelProperty(value = "购方集团id")
    private Long purchaserGroupId;

    @ApiModelProperty(value = "销方税号")
    private String sellerTaxNo;

    @ApiModelProperty(value = "销方名称")
    private String sellerName;

    @ApiModelProperty(value = "购方税号")
    private String purchaserTaxNo;

    @ApiModelProperty(value = "购方名称")
    private String purchaserName;

    @ApiModelProperty(value = "发票类型")
    private String invoiceType;

    @ApiModelProperty(value = "不含税金额")
    private BigDecimal amountWithoutTax;

    @ApiModelProperty(value = "税额")
    private BigDecimal taxAmount;

    @ApiModelProperty(value = "价税合计")
    private BigDecimal amountWithTax;

    @ApiModelProperty(value = "开具类型")
    private Integer makeOutType;

    @ApiModelProperty(value = "终端类型")
    private Integer terminalType;

    @ApiModelProperty(value = "重试次数")
    private Integer retryTimes;

    @ApiModelProperty(value = "终端代码")
    private String terminalCode;

    @ApiModelProperty(value = "处理备注")
    private String processRemark;

    @ApiModelProperty(value = "更新时间")
    private String updateTime;

    @ApiModelProperty(value = "操作人")
    private String operationName;

    /**
     * 处理状态 0-开具中 1-成功 2-失败
     * 表 : inv_seller_make_out_request
     * 对应字段 : process_status
     */
    @ApiModelProperty(value = "processStatus")
    private Integer processStatus;

    @ApiModelProperty(value = "suspectedFlag")
    private String suspectedFlag;


    public String getInvoiceType() {
        return invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getPreInvoiceId() {
        return preInvoiceId;
    }

    public void setPreInvoiceId(Long preInvoiceId) {
        this.preInvoiceId = preInvoiceId;
    }

    public String getSalesbillNo() {
        return salesbillNo;
    }

    public void setSalesbillNo(String salesbillNo) {
        this.salesbillNo = salesbillNo;
    }

    public Long getSellerGroupId() {
        return sellerGroupId;
    }

    public void setSellerGroupId(Long sellerGroupId) {
        this.sellerGroupId = sellerGroupId;
    }

    public Long getPurchaserGroupId() {
        return purchaserGroupId;
    }

    public void setPurchaserGroupId(Long purchaserGroupId) {
        this.purchaserGroupId = purchaserGroupId;
    }

    public String getSellerTaxNo() {
        return sellerTaxNo;
    }

    public void setSellerTaxNo(String sellerTaxNo) {
        this.sellerTaxNo = sellerTaxNo;
    }

    public String getSellerName() {
        return sellerName;
    }

    public void setSellerName(String sellerName) {
        this.sellerName = sellerName;
    }

    public String getPurchaserTaxNo() {
        return purchaserTaxNo;
    }

    public void setPurchaserTaxNo(String purchaserTaxNo) {
        this.purchaserTaxNo = purchaserTaxNo;
    }

    public String getPurchaserName() {
        return purchaserName;
    }

    public void setPurchaserName(String purchaserName) {
        this.purchaserName = purchaserName;
    }

    public BigDecimal getAmountWithoutTax() {
        return amountWithoutTax;
    }

    public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
        this.amountWithoutTax = amountWithoutTax;
    }

    public BigDecimal getTaxAmount() {
        return taxAmount;
    }

    public void setTaxAmount(BigDecimal taxAmount) {
        this.taxAmount = taxAmount;
    }

    public BigDecimal getAmountWithTax() {
        return amountWithTax;
    }

    public void setAmountWithTax(BigDecimal amountWithTax) {
        this.amountWithTax = amountWithTax;
    }

    public Integer getMakeOutType() {
        return makeOutType;
    }

    public void setMakeOutType(Integer makeOutType) {
        this.makeOutType = makeOutType;
    }

    public Integer getTerminalType() {
        return terminalType;
    }

    public void setTerminalType(Integer terminalType) {
        this.terminalType = terminalType;
    }

    public Integer getRetryTimes() {
        return retryTimes;
    }

    public void setRetryTimes(Integer retryTimes) {
        this.retryTimes = retryTimes;
    }

    public String getTerminalCode() {
        return terminalCode;
    }

    public void setTerminalCode(String terminalCode) {
        this.terminalCode = terminalCode;
    }

    public String getProcessRemark() {
        return processRemark;
    }

    public void setProcessRemark(String processRemark) {
        this.processRemark = processRemark;
    }

    public String getUpdateTime() {
        return updateTime;
    }

    public void setUpdateTime(String updateTime) {
        this.updateTime = updateTime;
    }

    public String getOperationName() {
        return operationName;
    }

    public void setOperationName(String operationName) {
        this.operationName = operationName;
    }

    public Integer getProcessStatus() {
        return processStatus;
    }

    public void setProcessStatus(Integer processStatus) {
        this.processStatus = processStatus;
    }

    public String getSuspectedFlag() {
        return suspectedFlag;
    }

    public void setSuspectedFlag(String suspectedFlag) {
        this.suspectedFlag = suspectedFlag;
    }
}
