package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 请求对象
 */
@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetInvoiceRedNoByBillRequest {
  @JsonProperty("billId")
  private Long billId = null;

  @JsonProperty("businessBillType")
  private String businessBillType = null;

  @JsonProperty("userRole")
  private String userRole = null;

  @JsonProperty("applyingStatus")
  private Integer applyingStatus = null;

  @JsonProperty("sellerTaxNo")
  private String sellerTaxNo = null;

  @JsonProperty("purchaserTaxNo")
  private String purchaserTaxNo = null;

  @JsonProperty("billNo")
  private String billNo = null;

  @JsonProperty("invoiceCode")
  private String invoiceCode = null;

  @JsonProperty("invoiceNo")
  private String invoiceNo = null;

  @JsonProperty("applyTaxNo")
  private String applyTaxNo = null;

  @JsonProperty("applyStatus")
  private Integer applyStatus = null;

  @JsonProperty("createTime")
  private String createTime = null;

  @JsonProperty("pageNo")
  private Integer pageNo = null;

  @JsonProperty("pageSize")
  private Integer pageSize = null;

  @JsonProperty("isHaveBillNo")
  private Boolean isHaveBillNo = null;

  @JsonProperty("ids")
  private List<Long> ids = new ArrayList<Long>();

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest billId(Long billId) {
    this.billId = billId;
    return this;
  }

   /**
   * 主键ID
   * @return billId
  **/
  @ApiModelProperty(value = "主键ID")
  public Long getBillId() {
    return billId;
  }

  public void setBillId(Long billId) {
    this.billId = billId;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest businessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
    return this;
  }

   /**
   * AP：购方 AR-销方
   * @return businessBillType
  **/
  @ApiModelProperty(value = "AP：购方 AR-销方")
  public String getBusinessBillType() {
    return businessBillType;
  }

  public void setBusinessBillType(String businessBillType) {
    this.businessBillType = businessBillType;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest userRole(String userRole) {
    this.userRole = userRole;
    return this;
  }

   /**
   * 1 销方 2购方
   * @return userRole
  **/
  @ApiModelProperty(value = "1 销方 2购方")
  public String getUserRole() {
    return userRole;
  }

  public void setUserRole(String userRole) {
    this.userRole = userRole;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest applyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
    return this;
  }

   /**
   * 申请状态:1 未申请 2.申请中 3.已申请 4.全部
   * @return applyingStatus
  **/
  @ApiModelProperty(value = "申请状态:1 未申请 2.申请中 3.已申请 4.全部")
  public Integer getApplyingStatus() {
    return applyingStatus;
  }

  public void setApplyingStatus(Integer applyingStatus) {
    this.applyingStatus = applyingStatus;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest sellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
    return this;
  }

   /**
   * 销方税号
   * @return sellerTaxNo
  **/
  @ApiModelProperty(value = "销方税号")
  public String getSellerTaxNo() {
    return sellerTaxNo;
  }

  public void setSellerTaxNo(String sellerTaxNo) {
    this.sellerTaxNo = sellerTaxNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest purchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
    return this;
  }

   /**
   * 购方税号
   * @return purchaserTaxNo
  **/
  @ApiModelProperty(value = "购方税号")
  public String getPurchaserTaxNo() {
    return purchaserTaxNo;
  }

  public void setPurchaserTaxNo(String purchaserTaxNo) {
    this.purchaserTaxNo = purchaserTaxNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest billNo(String billNo) {
    this.billNo = billNo;
    return this;
  }

   /**
   * 业务单号
   * @return billNo
  **/
  @ApiModelProperty(value = "业务单号")
  public String getBillNo() {
    return billNo;
  }

  public void setBillNo(String billNo) {
    this.billNo = billNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest invoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
    return this;
  }

   /**
   * 发票代码
   * @return invoiceCode
  **/
  @ApiModelProperty(value = "发票代码")
  public String getInvoiceCode() {
    return invoiceCode;
  }

  public void setInvoiceCode(String invoiceCode) {
    this.invoiceCode = invoiceCode;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest invoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
    return this;
  }

   /**
   * 发票号码
   * @return invoiceNo
  **/
  @ApiModelProperty(value = "发票号码")
  public String getInvoiceNo() {
    return invoiceNo;
  }

  public void setInvoiceNo(String invoiceNo) {
    this.invoiceNo = invoiceNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest applyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
    return this;
  }

   /**
   * 红字信息表编号
   * @return applyTaxNo
  **/
  @ApiModelProperty(value = "红字信息表编号")
  public String getApplyTaxNo() {
    return applyTaxNo;
  }

  public void setApplyTaxNo(String applyTaxNo) {
    this.applyTaxNo = applyTaxNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest applyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
    return this;
  }

   /**
   * 申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？
   * @return applyStatus
  **/
  @ApiModelProperty(value = "申请状态:1. 审核通过,2. 审核不通过,3. 已核销,4. 已撤销,5.其他：其他状态？？？")
  public Integer getApplyStatus() {
    return applyStatus;
  }

  public void setApplyStatus(Integer applyStatus) {
    this.applyStatus = applyStatus;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest createTime(String createTime) {
    this.createTime = createTime;
    return this;
  }

   /**
   * 创建时间
   * @return createTime
  **/
  @ApiModelProperty(value = "创建时间")
  public String getCreateTime() {
    return createTime;
  }

  public void setCreateTime(String createTime) {
    this.createTime = createTime;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest pageNo(Integer pageNo) {
    this.pageNo = pageNo;
    return this;
  }

   /**
   * return pageno
   * @return pageNo
  **/
  @ApiModelProperty(value = "return pageno")
  public Integer getPageNo() {
    return pageNo;
  }

  public void setPageNo(Integer pageNo) {
    this.pageNo = pageNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest pageSize(Integer pageSize) {
    this.pageSize = pageSize;
    return this;
  }

   /**
   * return pagesize
   * @return pageSize
  **/
  @ApiModelProperty(value = "return pagesize")
  public Integer getPageSize() {
    return pageSize;
  }

  public void setPageSize(Integer pageSize) {
    this.pageSize = pageSize;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest isHaveBillNo(Boolean isHaveBillNo) {
    this.isHaveBillNo = isHaveBillNo;
    return this;
  }

   /**
   * 是否含有业务单号
   * @return isHaveBillNo
  **/
  @ApiModelProperty(value = "是否含有业务单号")
  public Boolean getIsHaveBillNo() {
    return isHaveBillNo;
  }

  public void setIsHaveBillNo(Boolean isHaveBillNo) {
    this.isHaveBillNo = isHaveBillNo;
  }

  @JsonIgnore
  public MsGetInvoiceRedNoByBillRequest ids(List<Long> ids) {
    this.ids = ids;
    return this;
  }

  public MsGetInvoiceRedNoByBillRequest addIdsItem(Long idsItem) {
    this.ids.add(idsItem);
    return this;
  }

   /**
   * 发票对象
   * @return ids
  **/
  @ApiModelProperty(value = "发票对象")
  public List<Long> getIds() {
    return ids;
  }

  public void setIds(List<Long> ids) {
    this.ids = ids;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetInvoiceRedNoByBillRequest getInvoiceRedNoByBillRequest = (MsGetInvoiceRedNoByBillRequest) o;
    return Objects.equals(this.billId, getInvoiceRedNoByBillRequest.billId) &&
        Objects.equals(this.businessBillType, getInvoiceRedNoByBillRequest.businessBillType) &&
        Objects.equals(this.userRole, getInvoiceRedNoByBillRequest.userRole) &&
        Objects.equals(this.applyingStatus, getInvoiceRedNoByBillRequest.applyingStatus) &&
        Objects.equals(this.sellerTaxNo, getInvoiceRedNoByBillRequest.sellerTaxNo) &&
        Objects.equals(this.purchaserTaxNo, getInvoiceRedNoByBillRequest.purchaserTaxNo) &&
        Objects.equals(this.billNo, getInvoiceRedNoByBillRequest.billNo) &&
        Objects.equals(this.invoiceCode, getInvoiceRedNoByBillRequest.invoiceCode) &&
        Objects.equals(this.invoiceNo, getInvoiceRedNoByBillRequest.invoiceNo) &&
        Objects.equals(this.applyTaxNo, getInvoiceRedNoByBillRequest.applyTaxNo) &&
        Objects.equals(this.applyStatus, getInvoiceRedNoByBillRequest.applyStatus) &&
        Objects.equals(this.createTime, getInvoiceRedNoByBillRequest.createTime) &&
        Objects.equals(this.pageNo, getInvoiceRedNoByBillRequest.pageNo) &&
        Objects.equals(this.pageSize, getInvoiceRedNoByBillRequest.pageSize) &&
        Objects.equals(this.isHaveBillNo, getInvoiceRedNoByBillRequest.isHaveBillNo) &&
        Objects.equals(this.ids, getInvoiceRedNoByBillRequest.ids);
  }

  @Override
  public int hashCode() {
    return Objects.hash(billId, businessBillType, userRole, applyingStatus, sellerTaxNo, purchaserTaxNo, billNo, invoiceCode, invoiceNo, applyTaxNo, applyStatus, createTime, pageNo, pageSize, isHaveBillNo, ids);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetInvoiceRedNoByBillRequest {\n");

    sb.append("    billId: ").append(toIndentedString(billId)).append("\n");
    sb.append("    businessBillType: ").append(toIndentedString(businessBillType)).append("\n");
    sb.append("    userRole: ").append(toIndentedString(userRole)).append("\n");
    sb.append("    applyingStatus: ").append(toIndentedString(applyingStatus)).append("\n");
    sb.append("    sellerTaxNo: ").append(toIndentedString(sellerTaxNo)).append("\n");
    sb.append("    purchaserTaxNo: ").append(toIndentedString(purchaserTaxNo)).append("\n");
    sb.append("    billNo: ").append(toIndentedString(billNo)).append("\n");
    sb.append("    invoiceCode: ").append(toIndentedString(invoiceCode)).append("\n");
    sb.append("    invoiceNo: ").append(toIndentedString(invoiceNo)).append("\n");
    sb.append("    applyTaxNo: ").append(toIndentedString(applyTaxNo)).append("\n");
    sb.append("    applyStatus: ").append(toIndentedString(applyStatus)).append("\n");
    sb.append("    createTime: ").append(toIndentedString(createTime)).append("\n");
    sb.append("    pageNo: ").append(toIndentedString(pageNo)).append("\n");
    sb.append("    pageSize: ").append(toIndentedString(pageSize)).append("\n");
    sb.append("    isHaveBillNo: ").append(toIndentedString(isHaveBillNo)).append("\n");
    sb.append("    ids: ").append(toIndentedString(ids)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
