package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.clientl.v2.mode.PurchaserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;


@ApiModel(description = "请求对象")

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetPreInvoiceByRedNoRequest {
  @JsonProperty("id")
  private Long id = null;

  @JsonProperty("purchaserInfo")
  private PurchaserInfo purchaserInfo = null;

  @JsonIgnore
  public MsGetPreInvoiceByRedNoRequest purchaserInfo(PurchaserInfo purchaserInfo) {
    this.purchaserInfo = purchaserInfo;
    return this;
  }

  @ApiModelProperty(value = "购方信息")
  public PurchaserInfo getPurchaserInfo() {
    return purchaserInfo;
  }

  public void setPurchaserInfo(PurchaserInfo purchaserInfo) {
    this.purchaserInfo = purchaserInfo;
  }

  @JsonIgnore
  public MsGetPreInvoiceByRedNoRequest id(Long id) {
    this.id = id;
    return this;
  }

   /**
   * ID
   * @return id
  **/
  @ApiModelProperty(value = "ID")
  public Long getId() {
    return id;
  }

  public void setId(Long id) {
    this.id = id;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetPreInvoiceByRedNoRequest getRedNoDetailRequest = (MsGetPreInvoiceByRedNoRequest) o;
    return Objects.equals(this.id, getRedNoDetailRequest.id) &&
        Objects.equals(this.purchaserInfo, getRedNoDetailRequest.purchaserInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, purchaserInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoDetailRequest {\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    purchaserInfo: ").append(toIndentedString(purchaserInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
