package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.xforceplus.seller.invoice.clientl.v2.mode.PurchaserInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 返回详情
 */
@ApiModel(description = "返回详情")
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(NON_NULL)
public class MsGetRedNoIssueInfoResponseResult {

  @JsonProperty("preInvoice")
  private PreInvoice preInvoice = null;

  @JsonProperty("purchaserInfoList")
  private List<PurchaserInfo> purchaserInfoList = new ArrayList<PurchaserInfo>();

  @ApiModelProperty("是否需要弹窗补购方信息")
  @JsonProperty("needFillPurchaserInfo")
  private Boolean needFillPurchaserInfo = false;

  @JsonIgnore
  public MsGetRedNoIssueInfoResponseResult preInvoice(PreInvoice preInvoice) {
    this.preInvoice = preInvoice;
    return this;
  }

   /**
   * return total
   * @return total
  **/
  @ApiModelProperty(value = "return preInvoice")
  public PreInvoice getPreInvoice() {
    return preInvoice;
  }

  public void setPreInvoice(PreInvoice preInvoice) {
    this.preInvoice = preInvoice;
  }

  @JsonIgnore
  public MsGetRedNoIssueInfoResponseResult purchaserInfoList(List<PurchaserInfo> purchaserInfoList) {
    this.purchaserInfoList = purchaserInfoList;
    return this;
  }

  public MsGetRedNoIssueInfoResponseResult addPurchaserInfoItem(PurchaserInfo listItem) {
    this.purchaserInfoList.add(listItem);
    return this;
  }

   /**
   * 返回详情
   * @return list
  **/
  @ApiModelProperty(value = "返回购方信息")
  public List<PurchaserInfo> getPurchaserInfoList() {
    return purchaserInfoList;
  }

  public void setPurchaserInfoList(List<PurchaserInfo> purchaserInfoList) {
    this.purchaserInfoList = purchaserInfoList;
  }


  @JsonIgnore
  public MsGetRedNoIssueInfoResponseResult needFillPurchaserInfo(Boolean needFillPurchaserInfo) {
    this.needFillPurchaserInfo = needFillPurchaserInfo;
    return this;
  }


  @ApiModelProperty(value = "return needFillPurchaserInfo")
  public Boolean getNeedFillPurchaserInfo() {
    return needFillPurchaserInfo;
  }

  public void setNeedFillPurchaserInfo(Boolean needFillPurchaserInfo) {
    this.needFillPurchaserInfo = needFillPurchaserInfo;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MsGetRedNoIssueInfoResponseResult getRedNoListByInvoiceResponseResult = (MsGetRedNoIssueInfoResponseResult) o;
    return Objects.equals(this.preInvoice, getRedNoListByInvoiceResponseResult.preInvoice) &&
        Objects.equals(this.purchaserInfoList, getRedNoListByInvoiceResponseResult.purchaserInfoList) &&
            Objects.equals(this.needFillPurchaserInfo, getRedNoListByInvoiceResponseResult.needFillPurchaserInfo);
  }

  @Override
  public int hashCode() {
    return Objects.hash(preInvoice, purchaserInfoList,needFillPurchaserInfo);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MsGetRedNoListByInvoiceResponseResult {\n");

    sb.append("    total: ").append(toIndentedString(preInvoice)).append("\n");
    sb.append("    list: ").append(toIndentedString(purchaserInfoList)).append("\n");
    sb.append("    needFillPurchaserInfo: ").append(toIndentedString(needFillPurchaserInfo)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}
