package com.xforceplus.seller.invoice.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.xforceplus.xplatframework.apimodel.PollingModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_NULL;

/**
 * 红冲轮询结果对象
 */
@ApiModel(description = "红冲轮询结果对象")
@JsonInclude(NON_NULL)
@Data
public class PollingRedFlushInvoiceResult extends PollingModel {

    @ApiModelProperty(value = "红冲发票失败总数")
    private int failedCount = 0;
    @ApiModelProperty(value = "红冲发票成功总数")
    private int successCount = 0;
    @ApiModelProperty(value = "红冲发票处理结果代码")
    private String code;

    @ApiModelProperty(value = "红冲发票总数")
    private int total;

    @ApiModelProperty(value = "失败原因")
    private String failReason;

}
